﻿using System;
using System.Linq;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

using System.IO;

namespace Notatnik
{
    public partial class Form1 : Form
    {
        //string schowek = "";
        bool tekstZmieniony = false;

        public Form1()
        {
            InitializeComponent();
            textBox1_TextChanged(null, null);
        }

        private void zaznaczWszystkoMenuItem_Click(object sender, EventArgs e)
        {
            textBox1.SelectAll();
        }

        private void usunMenuItem_Click(object sender, EventArgs e)
        {
            textBox1.SelectedText = "";
        }        

        private void wklejMenuItem_Click(object sender, EventArgs e)
        {
            //if (schowek != "") textBox1.SelectedText = schowek;
            try
            {
                IDataObject zawartoscSchowka = Clipboard.GetDataObject();
                if (zawartoscSchowka.GetDataPresent(DataFormats.StringFormat))
                    textBox1.SelectedText = zawartoscSchowka.GetData(DataFormats.StringFormat) as string;
            }
            catch (Exception exc)
            {
                MessageBox.Show(exc.Message);
            }
        }
        
        private void kopiujMenuItem_Click(object sender, EventArgs e)
        {
            //schowek = textBox1.SelectedText;
            try
            {                
                Clipboard.SetDataObject(textBox1.SelectedText);                
            }
            catch (Exception exc)
            {
                MessageBox.Show(exc.Message);
            }
        }

        private void wytnijMenuItem_Click(object sender, EventArgs e)
        {
            kopiujMenuItem_Click(sender, e);
            usunMenuItem_Click(sender, e);
        }

        private void cofnijMenuItem_Click(object sender, EventArgs e)
        {
            textBox1.Undo();
        }

        private void textBox1_TextChanged(object sender, EventArgs e)
        {
            cofnijMenuItem.Enabled = textBox1.CanUndo;
            if (e != null) tekstZmieniony = true;
            if (tekstZmieniony && !statusBar1.Text.EndsWith("(zmodyfikowany)")) statusBar1.Text += " (zmodyfikowany)";
        }


        private string CzytajPlikTekstowy(string nazwaPliku)
        {
            try
            {
                string tekst;
                using (StreamReader sr = new StreamReader(nazwaPliku))
                {
                    tekst = sr.ReadToEnd();
                    sr.Close();
                }
                return tekst;
            }
            catch (Exception exc)
            {
                //Uwaga! Komunikat może nie zmieścić się na ekranie
                MessageBox.Show(
                    "Błąd odczytu pliku " + nazwaPliku + " (" + exc.Message + ")", 
                    "Błąd przy wczytywaniu pliku", 
                    MessageBoxButtons.OK,
                    MessageBoxIcon.Hand,
                    MessageBoxDefaultButton.Button1);
                return null;
            }
        }

        private void otworzMenuItem_Click(object sender, EventArgs e)
        {
            if (openFileDialog1.ShowDialog() == DialogResult.OK)
            {
                string nazwaPliku = openFileDialog1.FileName;
                string tekst = CzytajPlikTekstowy(nazwaPliku);
                if (tekst != null)
                {
                    textBox1.Text = tekst;
                    int ostatniSlash = nazwaPliku.LastIndexOf('\\');
                    statusBar1.Text = nazwaPliku.Substring(
                        ostatniSlash + 1,
                        nazwaPliku.Length - ostatniSlash - 1);
                    tekstZmieniony = false;
                }
            }
        }

        private void ZapiszDoPlikuTekstowego(string nazwaPliku, string tekst)
        {
            try
            {
                using (StreamWriter sw = new StreamWriter(nazwaPliku,false,Encoding.Unicode))
                {
                    sw.Write(tekst);
                }
            }
            catch (Exception exc)
            {
                //Uwaga! Komunikat może nie zmieścić się na ekranie
                MessageBox.Show(
                    "Błąd odczytu pliku " + nazwaPliku + " (" + exc.Message + ")",
                    "Błąd przy wczytywaniu pliku",
                    MessageBoxButtons.OK,
                    MessageBoxIcon.Hand,
                    MessageBoxDefaultButton.Button1);
            }
        }

        private void zapiszJakoMenuItem_Click(object sender, EventArgs e)
        {
            string nazwaPliku = openFileDialog1.FileName;
            if (nazwaPliku.Length > 0) saveFileDialog1.FileName = nazwaPliku;
            if (saveFileDialog1.ShowDialog() == DialogResult.OK)
            {
                nazwaPliku = saveFileDialog1.FileName;
                ZapiszDoPlikuTekstowego(nazwaPliku, textBox1.Text);
                int ostatniSlash = nazwaPliku.LastIndexOf('\\');
                statusBar1.Text = nazwaPliku.Substring(
                    ostatniSlash + 1,
                    nazwaPliku.Length - ostatniSlash - 1);
                tekstZmieniony = false;
            }
        }

        private void zakonczMenuItem_Click(object sender, EventArgs e)
        {
            Close();
        }

        private void Form1_Closing(object sender, CancelEventArgs e)
        {
            if (!tekstZmieniony) return;

            DialogResult wybor = MessageBox.Show(
                "Czy zapisać zmiany w edytowanym dokumencie?",
                this.Text, 
                MessageBoxButtons.YesNoCancel,
                MessageBoxIcon.Question, 
                MessageBoxDefaultButton.Button3);
            switch (wybor)
            {
                case DialogResult.Yes: 
                    zapiszJakoMenuItem_Click(null, null); 
                    break;
                case DialogResult.No: 
                    break;
                case DialogResult.Cancel: 
                    e.Cancel = true; 
                    break;
                default: 
                    e.Cancel = true; 
                    break;
            }
        }

        private void pasekStanuMenuItem_Click(object sender, EventArgs e)
        {
            pasekStanuMenuItem.Checked = !pasekStanuMenuItem.Checked;
            statusBar1.Visible = pasekStanuMenuItem.Checked;
        }

        private void zawijanieWierszyMenuItem_Click(object sender, EventArgs e)
        {
            zawijanieWierszyMenuItem.Checked = !zawijanieWierszyMenuItem.Checked;
            textBox1.WordWrap = zawijanieWierszyMenuItem.Checked;
        }

        private void Form1_KeyDown(object sender, KeyEventArgs e)
        {
            if ((e.KeyCode == System.Windows.Forms.Keys.Up))
            {
                // Up
            }
            if ((e.KeyCode == System.Windows.Forms.Keys.Down))
            {
                // Down
            }
            if ((e.KeyCode == System.Windows.Forms.Keys.Left))
            {
                // Left
            }
            if ((e.KeyCode == System.Windows.Forms.Keys.Right))
            {
                // Right
            }
            if ((e.KeyCode == System.Windows.Forms.Keys.Enter))
            {
                // Enter
            }

        }
    }
}